#include <iostream>
#include <vector>
#include <algorithm>

using namespace std;


/*
Mindegyik árbócra: csak akkor van olyan pont , ami >= magasságú, ha van olyan árbóc, ami >= magasságú.
Ha van A árbóc, akkor a válasza a legközelebbi B árbóctól függ, amire h_B>=h_A.
Ha B a leközelebbi ilyen árbóc, akkor a távolság: dx-dh

*/

struct Arboc {
    int x, h, ind;
};

bool comp(const Arboc& a, const Arboc& b) {
    return a.h > b.h;
}

int main()
{
    ios::sync_with_stdio(false);
    cin.tie(0);
    int n;
    cin >> n;
    vector<Arboc> arb(n);
    vector<int>ans(n);
    for (int i = 0;i < n;i++) {
        cin >> arb[i].x;
    }
    for (int i = 0;i < n;i++) {
        cin >> arb[i].h;
        arb[i].ind = i;
    }
    sort(arb.begin(), arb.end(), comp);
    for (int i = 0;i < n;i++) {
        int mind = 1000000023;
        for (int j = i-1;j >= 0;j--) {
            mind = min(mind, abs(arb[i].x - arb[j].x) - arb[j].h + arb[i].h);
        }
        for (int j = i + 1;j < n;j++) {
            if (arb[j].h < arb[i].h)break;
            mind = min(mind, abs(arb[i].x - arb[j].x));
        }
        ans[arb[i].ind] = (mind == 1000000023) ? -1 : mind;
    }
    for (int i = 0;i < n;i++) {
        cout << ans[i] << "\n";
    }
}